package tp1;
/**
 * Reprsente un numro de tlphone. Un numero de tlphone est dfini par un
 * couple :<br>
 * <UL>
 * <LI>un entier : le numro de tlphone proprement dit.</LI>
 * <LI>une lettre qui indique le type de numro ( 'T' : poste fixe
 * professionnel, 'D' poste fixe domicile, 'P' : portable, 'F' :fax).</LI>
 * </UL>
 * 
 * */

public class NumTel {

	// ----------------------------------------------
	// constantes
	// ----------------------------------------------
	/**
	 * telephone fixe professionnel
	 */
	public static final char FIXE_PROF = 'T';

	/**
	 * telephone fixe domicile
	 */
	public static final char FIXE_DOM = 'D';

	/**
	 * telephone portable
	 */
	public static final char PORTABLE = 'P';

	/**
	 * fax
	 */
	public static final char FAX = 'F';

	/**
	 * nature du numro inconnue
	 */
	public static final char INCONNU = '?';

	// ----------------------------------------------
	// attributs (variables de classes)
	// ----------------------------------------------
	private int numero;

	private char type;

	// ----------------------------------------------
	// Constructeurs
	// ----------------------------------------------

	/**
	 * cre un numro de tlphone d'un type donn.
	 * 
	 * @param num
	 *            le numro de tlphone
	 * @param type
	 *            son type (si ce type n'est pas 'T','D','P' ou 'F', la valeur
	 *            INCONNU ('?') sera associe  ce numro).
	 */
	public NumTel(int num, char type) {
		this.numero = num;
		setType(type);
	}

	/**
	 * cre un numro de tlphone de type inconnu
	 * 
	 * @param num
	 *            le numro de tlphone
	 */
	public NumTel(int num) {
		this(num, INCONNU);
	}

	// ----------------------------------------------
	// mthodes
	// ----------------------------------------------

	// ---- accesseurs --------------------------------------
	/**
	 * retourne le numro de tlphone
	 * 
	 * @return le numro.
	 */
	public int getNumero() {
		return numero;
	}

	/**
	 * retourne le type de ce numro de tlphone
	 * 
	 * @return le type.
	 */
	public char getType() {
		return type;
	}

	// ---- modifieurs --------------------------------------
	/**
	 * change le type de ce numro de tlphone
	 * 
	 * @param type
	 *            le nouveau type pour ce numro. (si ce type n'est pas
	 *            'T','D','P' ou 'F', la valeur INCONNU ('?') sera associe  ce
	 *            numro).
	 */
	public void setType(char type) {
		switch (type) {
		case FIXE_PROF:
		case FIXE_DOM:
		case PORTABLE:
		case FAX:
			this.type = type;
			break;
		default:
			this.type = INCONNU;
		}
	}

	// -------------------------------------------------------
	// mthodes hrites de la classe Object et redfinies
	// -------------------------------------------------------

	/**
	 * renvoie une reprsentation textuelle du numro de tlphone sous la forme
	 * d'une chane de caractres. Cette chaine et de la forme suivante :<br>
	 * <I>numro</I> <B>(</B><I>Type</I><B>)</B>).
	 * 
	 * @return la chaine correspondant au numro de tlphone et  son type
	 */
	public String toString() {
		return numero + " (" + type + ")";
	}

	/**
	 * teste l'galit de ce numro de tlphone avec un autre. L'galit porte
	 * uniquement sur le numro et ne tient pas compte du type.
	 * 
	 * @param o
	 *            le numro de tlphone  comparer avec ce numro.
	 * @return <code>false</code> si l'objet o n'est pas de type NumTel ou si
	 *         son numro n'est pas identique  celui de l'objet NumTel
	 *         rcepteur du message, <code>false</code> sinon.
	 */
	public boolean equals(Object o) {
		if (this == o) return true;
		if (o== null) return false;
	    if (o.getClass()!= this.getClass())
				return false;
		NumTel num = (NumTel) o;

		return this.numero == num.numero;
	}

	/**
	 * redfinition de la mthode hashCode pour rester cohrent avec la mthode
	 * equals. deux NumTel gaux doivent produirent le mme hashCode. voir le
	 * javadoc de la classe Object.
	 * 
	 * @return la valeur de hashCode
	 */
	public int hashCode() {
		return numero;
	}

}// NumTel
